import numpy as np


def test_delta():
    from soe.meanrisk import MRM

    # small sample
    samples = np.array([1, 2, 4, 5])
    mrm = MRM(samples)

    def f(x):
        d = (mrm.mean - x)
        return d * (d > 0)

    x = mrm.quantile_function(np.linspace(0, 1, 100))
    assert mrm.delta == np.mean(f(x))


def test_compute_all_score():
    from soe.meanrisk import MRM

    # small sample
    samples1 = np.random.randn(100)
    samples2 = 1.0 + np.random.randn(100)

    mrm1 = MRM(samples1)
    mrm2 = MRM(samples2)

    scores1, info1 = mrm1.compute()
    scores2, info2 = mrm2.compute()

    s1 = np.array(list(scores1.values()))
    s2 = np.array(list(scores2.values()))
    assert all(s1 < s2)

    assert info1["mean"]  < info2["mean"]
